#!/bin/sh
#
# $Header: lsnodes.sh 09-may-2005.04:30:50 vseethar Exp $
#
# lsnodes.sh
#
# Copyright (c) 2005, Oracle. All rights reserved.  
#
#    NAME
#      lsnodes.sh - <one-line expansion of the name>
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    vseethar    05/09/05 - vseethar_coes9204
#    vseethar    04/25/05 - Creation
#
#!/bin/sh

base=`dirname $0`

cd $base

#first check if CM is running
cmpid=`ps -elf | grep oracm | grep -v grep`
if [ $? != 0 ]; then
	echo "PRE10GCM"
	exit;
fi

#first check if something is already present in central loc.
if [ -d /etc/ORCLcluster/oracm/lib ]; then
	CL="/etc/ORCLcluster/oracm/lib"
	export LD_LIBRARY_PATH=$CL:$LD_LIBRARY_PATH
	cd $base
	ret=`./lsnodes`
	if [ $? = 0 ]; then
		echo "CL";
		exit;
	fi 
fi

export LD_LIBRARY_PATH=$base/9204
cd $base
chmod 755 $base/9204/lsnodes
ret=`./9204/lsnodes`
if [ $? = 0 ]; then
	echo "9204";
        exit;
fi

export LD_LIBRARY_PATH=$base/9201
chmod 755 $base/9201/lsnodes
ret=`./9201/lsnodes`
if [ $? = 0 ]; then
	wddpid=`ps -elf | grep watchdogd | grep -v grep`
	if [ $? = 0 ]; then
		echo "9201";
                exit;
	fi
fi

export LD_LIBRARY_PATH=$base/9014
chmod 755 $base/9014/lsnodes
ret=`./9014/lsnodes`
if [ $? = 0 ]; then
	echo "901"
        exit;
fi
